<?php

namespace Beedask\Models;

use Illuminate\Database\Eloquent\Model;

class Member extends Model 
{

    protected $table = 'members';
    public $timestamps = true;
    protected $fillable = array('user_id', 'party_id', 'title');
    protected $visible = array('user_id', 'party_id', 'title');

    public function answers()
    {
        return $this->hasMany('Answer', 'user_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function party()
    {
        return $this->belongsTo('Party', 'party_id');
    }

}